<?php

namespace app\models;

use Yii;
use yii\db\ActiveRecord;

/**
 * This is the model class for table "application".
 *
 * @property int $id
 * @property string $content
 * @property string $date_study
 * @property int $payment_method
 * @property string $status
 * @property int $user_id
 *
 * @property User $user
 */
class Application extends ActiveRecord
{


    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'application';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            ['user_id','default', 'value'=> Yii::$app->user->getId()],
            [['status'], 'default', 'value' => 'Новая'],
            [['content', 'date_study', 'payment_method', 'user_id'], 'required'],
            [['payment_method', 'user_id'], 'integer'],
            [['content'], 'string', 'max' => 255],
            [['date_study'], 'string', 'max' => 30],
            [['status'], 'string', 'max' => 150],
           // [['user_id'], 'exist', 'skipOnError' => true, 'targetClass' => User::class, 'targetAttribute' => ['user_id' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'content' => 'Наименование курса',
            'date_study' => 'Дата начала обучения',
            'payment_method' => 'Выберите способ оплаты',
            'user_id' => 'User ID',
            'status' => 'Статус заявки'
        ];
    }

    /**
     * Gets query for [[User]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getUser()
    {
        return $this->hasOne(User::class, ['id' => 'user_id']);
    }

}
